import { RpcMessageFormat } from '../constants';
import * as msg from '../../messages';
import * as schema from './schema';
import type { RpcMessageCodec } from '../types';
import type { JsonValueCodec } from '../../../../json-pack/codecs/types';
export declare class JsonRpc2RpcMessageCodec implements RpcMessageCodec {
    id: string;
    format: RpcMessageFormat;
    encodeMessage(jsonCodec: JsonValueCodec, message: msg.ReactiveRpcMessage): void;
    encodeBatch(jsonCodec: JsonValueCodec, batch: msg.ReactiveRpcMessage[]): void;
    encode(jsonCodec: JsonValueCodec, batch: msg.ReactiveRpcMessage[]): Uint8Array;
    decodeBatch(jsonCodec: JsonValueCodec, uint8: Uint8Array): msg.ReactiveRpcMessage[];
    fromJson(message: schema.JsonRpc2Message): msg.ReactiveRpcMessage;
}
