import * as msg from '../messages';
import { RpcErrorCodes } from './caller/error';
import { Value } from '../messages/Value';
import type { RpcCaller } from './caller/RpcCaller';
import type { RpcApiMap } from './caller/types';
type Send = (messages: (msg.ReactiveRpcServerMessage | msg.NotificationMessage)[]) => void;
export interface RpcMessageStreamProcessorOptions<Ctx = unknown> {
    caller: RpcCaller<Ctx>;
    send: Send;
    bufferSize?: number;
    bufferTime?: number;
}
export interface RpcMessageStreamProcessorFromApiOptions<Ctx = unknown> extends Omit<RpcMessageStreamProcessorOptions<Ctx>, 'onCall'> {
    api: RpcApiMap<Ctx>;
}
export declare class RpcMessageStreamProcessor<Ctx = unknown> {
    protected readonly caller: RpcCaller<Ctx>;
    private readonly activeStreamCalls;
    protected send: (message: msg.ReactiveRpcServerMessage | msg.NotificationMessage) => void;
    onSend: Send;
    constructor({ caller, send, bufferSize, bufferTime }: RpcMessageStreamProcessorOptions<Ctx>);
    onMessage(message: msg.ReactiveRpcClientMessage, ctx: Ctx): void;
    onMessages(messages: msg.ReactiveRpcClientMessage[], ctx: Ctx): void;
    sendNotification(method: string, value: Value): void;
    protected sendCompleteMessage(id: number, value: Value | undefined): void;
    protected sendDataMessage(id: number, value: Value): void;
    protected sendErrorMessage(id: number, value: Value): void;
    protected sendUnsubscribeMessage(id: number): void;
    protected execStaticCall(id: number, name: string, request: unknown, ctx: Ctx): void;
    protected onStreamError: (id: number, error: Value) => void;
    stop(reason?: RpcErrorCodes): void;
    disconnect(): void;
    private sendError;
    private createStreamCall;
    onRequestDataMessage(message: msg.RequestDataMessage, ctx: Ctx): void;
    onRequestCompleteMessage(message: msg.RequestCompleteMessage, ctx: Ctx): void;
    onRequestErrorMessage(message: msg.RequestErrorMessage, ctx: Ctx): void;
    onUnsubscribeMessage(message: msg.ResponseUnsubscribeMessage): void;
    onNotificationMessage(message: msg.NotificationMessage, ctx: Ctx): void;
}
export {};
