import { IStaticRpcMethod, IStreamingRpcMethod } from '../types';
import { ApiRpcCaller } from '../caller/ApiRpcCaller';
export declare const sampleApi: {
    ping: IStaticRpcMethod<object, void, "pong">;
    delay: IStaticRpcMethod<object, {
        timeout?: number | undefined;
    }, {
        done: true;
        timeout: number;
    }>;
    notificationSetValue: IStaticRpcMethod<object, {
        value: number;
    }, void>;
    getValue: IStaticRpcMethod<object, void, {
        value: number;
    }>;
    delayStreaming: IStreamingRpcMethod<object, {
        timeout?: number | undefined;
    }, {
        done: true;
        timeout: number;
    }>;
    double: IStaticRpcMethod<object, {
        num: number;
    }, {
        num: number;
    }>;
    count: IStreamingRpcMethod<object, {
        count: number;
    }, number>;
    error: IStaticRpcMethod<object, void, void>;
    streamError: IStreamingRpcMethod<object, void, void>;
    'auth.users.get': IStaticRpcMethod<object, {
        id: string;
    }, {
        id: string;
        name: string;
        tags: string[];
    }>;
    'util.info': IStreamingRpcMethod<object, void, {
        commit: string;
        sha1: string;
    }>;
    'util.timer': IStreamingRpcMethod<object, void, number>;
    doubleStringWithValidation: IStaticRpcMethod<object, {
        foo: string;
    }, {
        bar: string;
    }>;
    doubleStringWithValidation2: IStreamingRpcMethod<object, {
        foo: string;
    }, {
        bar: string;
    }>;
    passthroughStream: IStreamingRpcMethod<object, unknown, unknown>;
};
export declare const createCaller: () => ApiRpcCaller<{
    ping: IStaticRpcMethod<object, void, "pong">;
    delay: IStaticRpcMethod<object, {
        timeout?: number | undefined;
    }, {
        done: true;
        timeout: number;
    }>;
    notificationSetValue: IStaticRpcMethod<object, {
        value: number;
    }, void>;
    getValue: IStaticRpcMethod<object, void, {
        value: number;
    }>;
    delayStreaming: IStreamingRpcMethod<object, {
        timeout?: number | undefined;
    }, {
        done: true;
        timeout: number;
    }>;
    double: IStaticRpcMethod<object, {
        num: number;
    }, {
        num: number;
    }>;
    count: IStreamingRpcMethod<object, {
        count: number;
    }, number>;
    error: IStaticRpcMethod<object, void, void>;
    streamError: IStreamingRpcMethod<object, void, void>;
    'auth.users.get': IStaticRpcMethod<object, {
        id: string;
    }, {
        id: string;
        name: string;
        tags: string[];
    }>;
    'util.info': IStreamingRpcMethod<object, void, {
        commit: string;
        sha1: string;
    }>;
    'util.timer': IStreamingRpcMethod<object, void, number>;
    doubleStringWithValidation: IStaticRpcMethod<object, {
        foo: string;
    }, {
        bar: string;
    }>;
    doubleStringWithValidation2: IStreamingRpcMethod<object, {
        foo: string;
    }, {
        bar: string;
    }>;
    passthroughStream: IStreamingRpcMethod<object, unknown, unknown>;
}, any, {
    ping: import("../methods/StaticRpcMethod").StaticRpcMethod<object, void, "pong">;
    delay: import("../methods/StaticRpcMethod").StaticRpcMethod<object, {
        timeout?: number | undefined;
    }, {
        done: true;
        timeout: number;
    }>;
    notificationSetValue: import("../methods/StaticRpcMethod").StaticRpcMethod<object, {
        value: number;
    }, void>;
    getValue: import("../methods/StaticRpcMethod").StaticRpcMethod<object, void, {
        value: number;
    }>;
    delayStreaming: import("../methods/StreamingRpcMethod").StreamingRpcMethod<object, {
        timeout?: number | undefined;
    }, {
        done: true;
        timeout: number;
    }>;
    double: import("../methods/StaticRpcMethod").StaticRpcMethod<object, {
        num: number;
    }, {
        num: number;
    }>;
    count: import("../methods/StreamingRpcMethod").StreamingRpcMethod<object, {
        count: number;
    }, number>;
    error: import("../methods/StaticRpcMethod").StaticRpcMethod<object, void, void>;
    streamError: import("../methods/StreamingRpcMethod").StreamingRpcMethod<object, void, void>;
    'auth.users.get': import("../methods/StaticRpcMethod").StaticRpcMethod<object, {
        id: string;
    }, {
        id: string;
        name: string;
        tags: string[];
    }>;
    'util.info': import("../methods/StreamingRpcMethod").StreamingRpcMethod<object, void, {
        commit: string;
        sha1: string;
    }>;
    'util.timer': import("../methods/StreamingRpcMethod").StreamingRpcMethod<object, void, number>;
    doubleStringWithValidation: import("../methods/StaticRpcMethod").StaticRpcMethod<object, {
        foo: string;
    }, {
        bar: string;
    }>;
    doubleStringWithValidation2: import("../methods/StreamingRpcMethod").StreamingRpcMethod<object, {
        foo: string;
    }, {
        bar: string;
    }>;
    passthroughStream: import("../methods/StreamingRpcMethod").StreamingRpcMethod<object, unknown, unknown>;
}>;
