import { RpcCaller, type RpcApiCallerOptions } from './RpcCaller';
import { FunctionStreamingType, FunctionType } from '../../../../json-type/type/classes';
import { StaticRpcMethod, type StaticRpcMethodOptions } from '../methods/StaticRpcMethod';
import { StreamingRpcMethod, type StreamingRpcMethodOptions } from '../methods/StreamingRpcMethod';
import type { SchemaOf, TypeOf, TypeSystem } from '../../../../json-type';
import type { TypeRouter } from '../../../../json-type/system/TypeRouter';
export interface TypedApiCallerOptions<Router extends TypeRouter<any>, Ctx = unknown> extends Omit<RpcApiCallerOptions<Ctx>, 'getMethod'> {
    router: Router;
}
export declare class TypeRouterCaller<Router extends TypeRouter<any>, Ctx = unknown> extends RpcCaller<Ctx> {
    protected readonly router: Router;
    protected readonly system: TypeSystem;
    protected readonly methods: Map<string, StaticRpcMethod<Ctx, unknown, unknown> | StreamingRpcMethod<Ctx, unknown, unknown>>;
    constructor({ router, ...rest }: TypedApiCallerOptions<Router, Ctx>);
    readonly req: {
        [K in keyof Routes<Router>]: MethodReq<Routes<Router>[K]>;
    };
    readonly res: {
        [K in keyof Routes<Router>]: MethodRes<Routes<Router>[K]>;
    };
    get<K extends keyof Routes<Router>>(id: K): MethodDefinition<Ctx, Routes<Router>[K]>;
    call<K extends keyof Routes<Router>>(id: K, request: MethodReq<Routes<Router>[K]>, ctx: Ctx): Promise<MethodRes<Routes<Router>[K]>>;
}
type Routes<Router> = Router extends TypeRouter<infer R> ? R : never;
type MethodReq<F> = F extends FunctionType<infer Req, any> ? TypeOf<SchemaOf<Req>> : F extends FunctionStreamingType<infer Req, any> ? TypeOf<SchemaOf<Req>> : never;
type MethodRes<F> = F extends FunctionType<any, infer Res> ? TypeOf<SchemaOf<Res>> : F extends FunctionStreamingType<any, infer Res> ? TypeOf<SchemaOf<Res>> : never;
type MethodDefinition<Ctx, F> = F extends FunctionType<any, any> ? StaticRpcMethodOptions<Ctx, MethodReq<F>, MethodRes<F>> : F extends FunctionStreamingType<any, any> ? StreamingRpcMethodOptions<Ctx, MethodReq<F>, MethodRes<F>> : never;
export {};
