import { IRpcMethodBase, IStaticRpcMethod } from './types';
export interface StaticRpcMethodOptions<Ctx = unknown, Req = unknown, Res = unknown> extends Omit<IRpcMethodBase<Ctx, Req, Res>, 'isStreaming' | 'call$'> {
}
export declare class StaticRpcMethod<Ctx = unknown, Req = unknown, Res = unknown> implements IStaticRpcMethod<Ctx, Req, Res> {
    readonly isStreaming = false;
    readonly pretty: boolean;
    readonly validate?: IStaticRpcMethod<Ctx, Req, Res>['validate'];
    readonly onPreCall?: (ctx: Ctx, request: Req) => Promise<void>;
    readonly req?: IStaticRpcMethod<Ctx, Req, Res>['req'];
    readonly res?: IStaticRpcMethod<Ctx, Req, Res>['res'];
    readonly call: IRpcMethodBase<Ctx, Req, Res>['call'];
    readonly call$: IRpcMethodBase<Ctx, Req, Res>['call$'];
    readonly acceptsNotifications: boolean;
    constructor(options: StaticRpcMethodOptions<Ctx, Req, Res>);
}
