"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.StaticRpcMethod = void 0;
const rxjs_1 = require("rxjs");
class StaticRpcMethod {
    constructor(options) {
        this.isStreaming = false;
        const { call, validate, onPreCall, pretty, req, res } = options;
        this.pretty = !!pretty;
        this.validate = validate;
        this.onPreCall = onPreCall;
        this.req = req;
        this.res = res;
        const responseIsVoid = !!res && res.getTypeName() === 'const' && res.getSchema().value === undefined;
        this.acceptsNotifications = responseIsVoid;
        this.call = call;
        this.call$ = (request$, ctx) => (0, rxjs_1.from)((async () => this.call(await (0, rxjs_1.firstValueFrom)(request$), ctx))());
    }
}
exports.StaticRpcMethod = StaticRpcMethod;
