import type { Observable } from 'rxjs';
import type { Type } from '../../../../json-type';
export interface IRpcMethodBase<Ctx = unknown, Req = unknown, Res = unknown> {
    isStreaming: boolean;
    validate?: (request: Req) => void;
    onPreCall?: (ctx: Ctx, request: Req) => Promise<void>;
    pretty?: boolean;
    req?: Type;
    res?: Type;
    call: (request: Req, ctx: Ctx) => Promise<Res>;
    call$: (request$: Observable<Req>, ctx: Ctx) => Observable<Res>;
}
export interface IStaticRpcMethod<Ctx = unknown, Req = unknown, Res = unknown> extends Omit<IRpcMethodBase<Ctx, Req, Res>, 'call$'> {
    isStreaming: false;
}
export interface IStreamingRpcMethod<Ctx = unknown, Req = unknown, Res = unknown> extends Omit<IRpcMethodBase<Ctx, Req, Res>, 'call'> {
    isStreaming: true;
    preCallBufferSize?: number;
}
export type RpcMethod<Ctx = unknown, Req = unknown, Res = unknown> = IStaticRpcMethod<Ctx, Req, Res> | IStreamingRpcMethod<Ctx, Req, Res>;
export type RpcMethodMap<Ctx = unknown> = {
    [name: string]: RpcMethod<Ctx>;
};
