import type { JsonValueCodec } from '../../json-pack/codecs/types';
import type { RpcMessageCodec } from '../common/codec/types';
import type { RpcApp } from './uws/RpcApp';
import type { HttpRequest, HttpResponse } from './uws/types';
import type { RpcCodecs } from '../common/codec/RpcCodecs';
export declare class ConnectionContext<Meta = Record<string, unknown>> {
    readonly ip: string;
    readonly token: string;
    readonly params: string[] | null;
    readonly meta: Meta;
    reqCodec: JsonValueCodec;
    resCodec: JsonValueCodec;
    msgCodec: RpcMessageCodec;
    res: HttpResponse | undefined;
    static fromReqRes(req: HttpRequest, res: HttpResponse, params: string[] | null, app: RpcApp<any>): ConnectionContext;
    constructor(ip: string, token: string, params: string[] | null, meta: Meta, reqCodec: JsonValueCodec, resCodec: JsonValueCodec, msgCodec: RpcMessageCodec, res?: HttpResponse | undefined);
    setCodecs(specifier: string, codecs: RpcCodecs): void;
    requestBodyParts(max: number): Promise<Uint8Array[]>;
    requestBody(max: number): Promise<Uint8Array>;
    requestBodyJson(max: number): Promise<unknown>;
    sendResponse(response: Uint8Array): void;
}
