import { BehaviorSubject, Observable } from 'rxjs';
export interface BlockModel<Data, Patch> {
    getData(): Data;
    fork(): BlockModel<Data, Patch>;
    apply(patch: Patch): void;
}
export declare class BasicBlock<Data, Patch> {
    readonly model: BlockModel<Data, Patch>;
    v$: BehaviorSubject<number>;
    constructor(version: number, model: BlockModel<Data, Patch>);
    fork(): BasicBlock<Data, Patch>;
    data$(): Observable<Data>;
    getData(): Data;
    apply(patch: Patch): void;
}
export type PatchResponse<Patch> = true | false | Patch;
export interface BranchMergeResponse<Patch> {
    version: number;
    batches: PatchResponse<Patch>[][];
}
export declare class Branch<Data, Patch> {
    protected readonly base$: BehaviorSubject<BasicBlock<Data, Patch>>;
    protected readonly head$: BehaviorSubject<BasicBlock<Data, Patch>>;
    protected patches: Patch[];
    protected batches: Patch[][];
    constructor(base: BasicBlock<Data, Patch>);
    cutBatch(): void;
    commit(patch: Patch): void;
    rebase(patches: Patch[]): void;
    reset(base: BasicBlock<Data, Patch>): Patch[];
}
