"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
const tslib_1 = require("tslib");
const fs_1 = require("fs");
const msgpack_1 = require("../json-pack/msgpack");
const CborDecoder_1 = require("../json-pack/cbor/CborDecoder");
const JSONB = tslib_1.__importStar(require("../json-binary"));
const arg_1 = tslib_1.__importDefault(require("arg"));
const args = (0, arg_1.default)({
    '--format': String,
    '--cbor': Boolean,
}, {
    argv: process.argv,
});
const ALLOWED_FORMATS = new Set(['msgpack', 'messagepack', 'cbor']);
const format = args['--cbor']
    ? 'cbor'
    : String((_a = args['--format']) !== null && _a !== void 0 ? _a : 'msgpack').toLowerCase();
if (!ALLOWED_FORMATS.has(format))
    throw new Error(`Unknown format: ${format}`);
try {
    switch (format) {
        case 'msgpack':
        case 'messagepack': {
            const decoder = new msgpack_1.MsgPackDecoderFast();
            const buf = (0, fs_1.readFileSync)(0);
            const arr = new Uint8Array(buf.length);
            for (let i = 0; i < buf.length; i++)
                arr[i] = buf[i];
            const decoded = decoder.decode(arr);
            const json = JSONB.stringify(decoded);
            process.stdout.write(json);
            break;
        }
        case 'cbor': {
            const decoder = new CborDecoder_1.CborDecoder();
            const buf = (0, fs_1.readFileSync)(0);
            const arr = new Uint8Array(buf.length);
            for (let i = 0; i < buf.length; i++)
                arr[i] = buf[i];
            const decoded = decoder.decode(arr);
            const json = JSONB.stringify(decoded);
            process.stdout.write(json);
            break;
        }
    }
}
catch (error) {
    const output = error instanceof Error ? error.message : String(error);
    process.stderr.write(output + '\n');
    process.exit(1);
}
