import { CrdtWriter } from '../../util/binary/CrdtWriter';
import { ITimespanStruct, ITimestampStruct } from '../../clock';
import { CborEncoder } from '../../../json-pack/cbor/CborEncoder';
import type { JsonCrdtPatchOperation, Patch } from '../../Patch';
export declare class Encoder extends CborEncoder<CrdtWriter> {
    readonly writer: CrdtWriter;
    private patchSid;
    constructor(writer?: CrdtWriter);
    encode(patch: Patch): Uint8Array;
    protected encodeOperations(patch: Patch): void;
    protected encodeId(id: ITimestampStruct): void;
    protected encodeTss(span: ITimespanStruct): void;
    private writeInsStr;
    protected encodeOperation(op: JsonCrdtPatchOperation): void;
}
