export interface JsonCodecPatch {
    id: [sessionId: number, time: number];
    ops: JsonCodecOperation[];
    meta?: unknown;
}
export type JsonCodecOperation = JsonCodecNewConOperation | JsonCodecNewValOperation | JsonCodecNewObjOperation | JsonCodecNewVecOperation | JsonCodecNewStrOperation | JsonCodecNewBinOperation | JsonCodecNewArrOperation | JsonCodecInsValOperation | JsonCodecInsObjOperation | JsonCodecInsVecOperation | JsonCodecInsStrOperation | JsonCodecInsBinOperation | JsonCodecInsArrOperation | JsonCodecDelOperation | JsonCodecNopOperation;
export type JsonCodecTimestamp = [
    sessionId: number,
    time: number
] | number;
export type JsonCodecTimespan = [
    sessionId: number,
    time: number,
    span: number
];
export type JsonCrdtPatchMnemonic = 'new_con' | 'new_val' | 'new_obj' | 'new_vec' | 'new_str' | 'new_bin' | 'new_arr' | 'ins_val' | 'ins_obj' | 'ins_vec' | 'ins_str' | 'ins_bin' | 'ins_arr' | 'del' | 'nop';
export interface JsonCodecOperationBase<T extends JsonCrdtPatchMnemonic> {
    op: T;
}
export type NotUndefined<T> = T extends undefined ? never : T;
export interface JsonCodecNewConOperation extends JsonCodecOperationBase<'new_con'> {
    value?: NotUndefined<unknown> | JsonCodecTimestamp;
    timestamp?: boolean;
}
export type JsonCodecNewValOperation = JsonCodecOperationBase<'new_val'>;
export type JsonCodecNewObjOperation = JsonCodecOperationBase<'new_obj'>;
export type JsonCodecNewVecOperation = JsonCodecOperationBase<'new_vec'>;
export type JsonCodecNewStrOperation = JsonCodecOperationBase<'new_str'>;
export type JsonCodecNewBinOperation = JsonCodecOperationBase<'new_bin'>;
export type JsonCodecNewArrOperation = JsonCodecOperationBase<'new_arr'>;
export interface JsonCodecObjectOperation<T extends JsonCrdtPatchMnemonic> extends JsonCodecOperationBase<T> {
    obj: JsonCodecTimestamp;
}
export interface JsonCodecInsValOperation extends JsonCodecObjectOperation<'ins_val'> {
    value: JsonCodecTimestamp;
}
export interface JsonCodecInsObjOperation extends JsonCodecObjectOperation<'ins_obj'> {
    value: Array<[key: string, value: JsonCodecTimestamp]>;
}
export interface JsonCodecInsVecOperation extends JsonCodecObjectOperation<'ins_vec'> {
    value: Array<[index: number, value: JsonCodecTimestamp]>;
}
export interface JsonCodecInsStrOperation extends JsonCodecObjectOperation<'ins_str'> {
    after: JsonCodecTimestamp;
    value: string;
}
export interface JsonCodecInsBinOperation extends JsonCodecObjectOperation<'ins_bin'> {
    after: JsonCodecTimestamp;
    value: string;
}
export interface JsonCodecInsArrOperation extends JsonCodecObjectOperation<'ins_arr'> {
    after: JsonCodecTimestamp;
    values: JsonCodecTimestamp[];
}
export interface JsonCodecDelOperation extends JsonCodecObjectOperation<'del'> {
    what: JsonCodecTimespan[];
}
export interface JsonCodecNopOperation extends JsonCodecOperationBase<'nop'> {
    len?: number;
}
