"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.hashModel = exports.hashNode = exports.updateNode = exports.updateRga = exports.updateId = void 0;
const json_hash_1 = require("../json-hash");
const nodes_1 = require("./nodes");
const rga_1 = require("./nodes/rga");
const util2_1 = require("../util/trees/util2");
const updateId = (state, id) => {
    const sid = id.sid;
    state = (0, json_hash_1.updateNum)(state, sid >>> 0);
    state = (0, json_hash_1.updateNum)(state, id.time);
    return state;
};
exports.updateId = updateId;
const updateRga = (state, node) => {
    state = (0, json_hash_1.updateNum)(state, node.length());
    state = (0, json_hash_1.updateNum)(state, node.size());
    const maxIdChunk = (0, util2_1.last2)(node.ids);
    if (maxIdChunk)
        state = (0, exports.updateId)(state, maxIdChunk.id);
    return (0, exports.updateId)(state, node.id);
};
exports.updateRga = updateRga;
const updateNode = (state, node) => {
    if (node instanceof nodes_1.ConNode)
        return (0, exports.updateId)(state, node.id);
    if (node instanceof nodes_1.ValNode) {
        const child = node.child();
        if (child)
            state = (0, exports.updateNode)(state, child);
        return (0, exports.updateId)(state, node.id);
    }
    if (node instanceof nodes_1.ObjNode || node instanceof nodes_1.VecNode) {
        node.children((child) => {
            state = (0, exports.updateNode)(state, child);
        });
        return (0, exports.updateId)(state, node.id);
    }
    if (node instanceof nodes_1.ArrNode) {
        node.children((child) => {
            state = (0, exports.updateNode)(state, child);
        });
    }
    if (node instanceof rga_1.AbstractRga)
        return (0, exports.updateRga)(state, node);
    throw new Error('UNKNOWN_NODE');
};
exports.updateNode = updateNode;
const hashNode = (node) => {
    return (0, exports.updateNode)(5381, node) >>> 0;
};
exports.hashNode = hashNode;
const hashModel = (model) => {
    return (0, exports.hashNode)(model.root);
};
exports.hashModel = hashModel;
