import { ConNode } from '../nodes/con/ConNode';
import { ITimestampStruct, IVectorClock, VectorClock } from '../../json-crdt-patch/clock';
import { JsonCrdtPatchOperation, Patch } from '../../json-crdt-patch/Patch';
import { ModelApi } from './api/ModelApi';
import { RootNode, BuilderNodeToJsonNode } from '../nodes';
import { Extensions } from '../extensions/Extensions';
import { AvlMap } from '../../util/trees/avl/AvlMap';
import type { JsonNode, JsonNodeView } from '../nodes/types';
import type { Printable } from '../../util/print/types';
import type { NodeBuilder } from '../../json-crdt-patch';
export declare const UNDEFINED: ConNode<undefined>;
export declare class Model<RootJsonNode extends JsonNode = JsonNode> implements Printable {
    static withLogicalClock(clockOrSessionId?: VectorClock | number): Model;
    static withServerClock(time?: number): Model;
    static fromBinary(data: Uint8Array): Model;
    root: RootNode<RootJsonNode>;
    clock: IVectorClock;
    index: AvlMap<ITimestampStruct, JsonNode<unknown>>;
    ext: Extensions;
    constructor(clock: IVectorClock);
    private _api?;
    get api(): ModelApi<RootJsonNode>;
    get find(): import("./proxy/types").ProxyNodeVal<RootNode<RootJsonNode>>;
    tick: number;
    onchange: undefined | (() => void);
    applyBatch(patches: Patch[]): void;
    applyPatch(patch: Patch): void;
    applyOperation(op: JsonCrdtPatchOperation): void;
    protected deleteNodeTree(value: ITimestampStruct): void;
    fork(sessionId?: number): Model<RootJsonNode>;
    clone(): Model<RootJsonNode>;
    view(): Readonly<JsonNodeView<RootJsonNode>>;
    toBinary(): Uint8Array;
    setSchema<S extends NodeBuilder>(schema: S): Model<BuilderNodeToJsonNode<S>>;
    toString(tab?: string): string;
}
