import { Path } from '../../../json-pointer';
import { ObjNode, ArrNode, BinNode, ConNode, VecNode, ValNode, StrNode } from '../../nodes';
import { ExtensionApi, ExtensionDefinition, ExtensionJsonNode } from '../../extensions/types';
import { NodeEvents } from './events/NodeEvents';
import type { JsonNode, JsonNodeView } from '../../nodes';
import type * as types from '../proxy/types';
import type { ModelApi } from './ModelApi';
import type { Printable } from '../../../util/print/types';
import type { JsonNodeApi } from './types';
export type ApiPath = string | number | Path | void;
export declare class NodeApi<N extends JsonNode = JsonNode> implements Printable {
    readonly node: N;
    readonly api: ModelApi<any>;
    constructor(node: N, api: ModelApi<any>);
    private ev;
    get events(): NodeEvents;
    find(path?: ApiPath): JsonNode;
    in(path?: ApiPath): ValApi<ValNode<any>>;
    asVal(): ValApi;
    asStr(): StrApi;
    asBin(): BinApi;
    asArr(): ArrApi;
    asTup(): VecApi;
    asObj(): ObjApi;
    asCon(): ConApi;
    asExt<EN extends ExtensionJsonNode, V, EApi extends ExtensionApi<EN>>(ext: ExtensionDefinition<any, EN, EApi>): EApi;
    val(path?: ApiPath): ValApi;
    str(path?: ApiPath): StrApi;
    bin(path?: ApiPath): BinApi;
    arr(path?: ApiPath): ArrApi;
    tup(path?: ApiPath): VecApi;
    obj(path?: ApiPath): ObjApi;
    const(path?: ApiPath): ConApi;
    view(): JsonNodeView<N>;
    toString(tab?: string): string;
}
export declare class ConApi<N extends ConNode<any> = ConNode<any>> extends NodeApi<N> {
    proxy(): types.ProxyNodeCon<N>;
}
export declare class ValApi<N extends ValNode<any> = ValNode<any>> extends NodeApi<N> {
    get(): JsonNodeApi<N extends ValNode<infer T> ? T : JsonNode>;
    set(json: JsonNodeView<N>): this;
    proxy(): types.ProxyNodeVal<N>;
}
type UnVecNode<N> = N extends VecNode<infer T> ? T : never;
export declare class VecApi<N extends VecNode<any> = VecNode<any>> extends NodeApi<N> {
    get<K extends keyof UnVecNode<N>>(key: K): JsonNodeApi<UnVecNode<N>[K]>;
    set(entries: [index: number, value: unknown][]): this;
    proxy(): types.ProxyNodeVec<N>;
}
type UnObjNode<N> = N extends ObjNode<infer T> ? T : never;
export declare class ObjApi<N extends ObjNode<any> = ObjNode<any>> extends NodeApi<N> {
    get<K extends keyof UnObjNode<N>>(key: K): JsonNodeApi<UnObjNode<N>[K]>;
    set(entries: Partial<JsonNodeView<N>>): this;
    del(keys: string[]): this;
    proxy(): types.ProxyNodeObj<N>;
}
export declare class StrApi extends NodeApi<StrNode> {
    ins(index: number, text: string): this;
    del(index: number, length: number): this;
    proxy(): types.ProxyNodeStr;
}
export declare class BinApi extends NodeApi<BinNode> {
    ins(index: number, data: Uint8Array): this;
    del(index: number, length: number): this;
    proxy(): types.ProxyNodeBin;
}
type UnArrNode<N> = N extends ArrNode<infer T> ? T : never;
export declare class ArrApi<N extends ArrNode<any> = ArrNode<any>> extends NodeApi<N> {
    get(index: number): JsonNodeApi<UnArrNode<N>>;
    ins(index: number, values: Array<JsonNodeView<N>[number]>): this;
    del(index: number, length: number): this;
    length(): number;
    proxy(): types.ProxyNodeArr<N>;
}
export {};
