import type { JsonNode } from '..';
import { ITimestampStruct } from '../../../json-crdt-patch/clock';
import { AbstractRga, Chunk } from '../rga/AbstractRga';
export declare class BinChunk implements Chunk<Uint8Array> {
    readonly id: ITimestampStruct;
    span: number;
    del: boolean;
    data: Uint8Array | undefined;
    len: number;
    p: BinChunk | undefined;
    l: BinChunk | undefined;
    r: BinChunk | undefined;
    p2: BinChunk | undefined;
    l2: BinChunk | undefined;
    r2: BinChunk | undefined;
    s: BinChunk | undefined;
    constructor(id: ITimestampStruct, span: number, buf: Uint8Array | undefined);
    merge(data: Uint8Array): void;
    split(ticks: number): BinChunk;
    delete(): void;
    clone(): BinChunk;
}
export declare class BinNode extends AbstractRga<Uint8Array> implements JsonNode<Uint8Array> {
    private _view;
    view(): Readonly<Uint8Array>;
    children(): void;
    child(): undefined;
    container(): JsonNode | undefined;
    api: undefined | unknown;
    createChunk(id: ITimestampStruct, buf: Uint8Array | undefined): BinChunk;
    protected onChange(): void;
    protected toStringName(): string;
}
