"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.ValNode = void 0;
const clock_1 = require("../../../json-crdt-patch/clock");
const printTree_1 = require("../../../util/print/printTree");
const Model_1 = require("../../model/Model");
class ValNode {
    constructor(doc, id, val) {
        this.doc = doc;
        this.id = id;
        this.val = val;
        this.api = undefined;
    }
    set(val) {
        if ((0, clock_1.compare)(val, this.val) <= 0 && this.val.sid !== 0)
            return;
        if ((0, clock_1.compare)(val, this.id) <= 0)
            return;
        const oldVal = this.val;
        this.val = val;
        return oldVal;
    }
    node() {
        return this.val.sid === 0 ? Model_1.UNDEFINED : this.child();
    }
    view() {
        return this.node().view();
    }
    children(callback) {
        callback(this.node());
    }
    child() {
        return this.doc.index.get(this.val);
    }
    container() {
        const child = this.node();
        return child ? child.container() : undefined;
    }
    toString(tab = '') {
        const node = this.node();
        const header = this.constructor.name + ' ' + (0, clock_1.toDisplayString)(this.id);
        return header + (0, printTree_1.printTree)(tab, [(tab) => (node ? node.toString(tab) : (0, clock_1.toDisplayString)(this.val))]);
    }
}
exports.ValNode = ValNode;
