import { Patch } from '../../json-crdt-patch';
import { ClockTable } from '../../json-crdt-patch/codec/clock/ClockTable';
import { Decoder } from '../codec/indexed/binary/Decoder';
import { Encoder } from '../codec/indexed/binary/Encoder';
import { IndexedFields, IndexedNodeFields } from '../codec/indexed/binary/types';
import { PartialEditModel } from './PartialEditModel';
import type { FieldEdits } from './types';
export declare class PartialEdit {
    protected readonly decoder: Decoder;
    protected readonly encoder: Encoder;
    readonly clockTable: ClockTable;
    loadList: Set<string>;
    doc: PartialEditModel | null;
    constructor(decoder: Decoder, encoder: Encoder, clockTable?: ClockTable);
    populateLoadList(patch: Patch): void;
    getFieldsToLoad(): Set<string>;
    loadPartialModel(fields: IndexedNodeFields): PartialEditModel;
    applyPatch(patch: Patch): void;
    populateClockTable(): void;
    getFieldEdits(): FieldEdits;
}
export declare class PartialEditFactory {
    protected readonly decoder: Decoder;
    protected readonly encoder: Encoder;
    constructor(decoder: Decoder, encoder: Encoder);
    startPartialEdit(clockBlob: IndexedFields['c']): PartialEdit;
}
