"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.typeOperators = void 0;
const tslib_1 = require("tslib");
const codegen_steps_1 = require("../codegen-steps");
const util = tslib_1.__importStar(require("../util"));
exports.typeOperators = [
    [
        'type',
        [],
        1,
        (expr, ctx) => {
            return util.type(ctx.eval(expr[1], ctx));
        },
        (ctx) => {
            ctx.link(util.type, 'type');
            const js = `type(${ctx.operands[0]})`;
            return new codegen_steps_1.Expression(js);
        },
    ],
    [
        'bool',
        [],
        1,
        (expr, ctx) => {
            return !!ctx.eval(expr[1], ctx);
        },
        (ctx) => {
            const js = `!!${ctx.operands[0]}`;
            return new codegen_steps_1.Expression(js);
        },
    ],
    [
        'num',
        [],
        1,
        (expr, ctx) => {
            return util.num(ctx.eval(expr[1], ctx));
        },
        (ctx) => {
            const js = `+(${ctx.operands[0]})||0`;
            return new codegen_steps_1.Expression(js);
        },
    ],
    [
        'str',
        [],
        1,
        (expr, ctx) => {
            return util.str(ctx.eval(expr[1], ctx));
        },
        (ctx) => {
            ctx.link(util.str, 'str');
            const js = `str(${ctx.operands[0]})`;
            return new codegen_steps_1.Expression(js);
        },
    ],
    [
        'len',
        [],
        1,
        (expr, ctx) => {
            return util.len(ctx.eval(expr[1], ctx));
        },
        (ctx) => {
            ctx.link(util.len, 'len');
            const js = `len(${ctx.operands[0]})`;
            return new codegen_steps_1.Expression(js);
        },
    ],
    [
        'und?',
        [],
        1,
        (expr, ctx) => {
            return ctx.eval(expr[1], ctx) === undefined;
        },
        (ctx) => {
            const js = `(${ctx.operands[0]})===undefined`;
            return new codegen_steps_1.Expression(js);
        },
    ],
    [
        'nil?',
        [],
        1,
        (expr, ctx) => {
            return ctx.eval(expr[1], ctx) === null;
        },
        (ctx) => {
            const js = `(${ctx.operands[0]})===null`;
            return new codegen_steps_1.Expression(js);
        },
    ],
    [
        'bool?',
        [],
        1,
        (expr, ctx) => {
            return typeof ctx.eval(expr[1], ctx) === 'boolean';
        },
        (ctx) => {
            const js = `typeof(${ctx.operands[0]})==='boolean'`;
            return new codegen_steps_1.Expression(js);
        },
    ],
    [
        'num?',
        [],
        1,
        (expr, ctx) => {
            return typeof ctx.eval(expr[1], ctx) === 'number';
        },
        (ctx) => {
            const js = `typeof(${ctx.operands[0]})==='number'`;
            return new codegen_steps_1.Expression(js);
        },
    ],
    [
        'str?',
        [],
        1,
        (expr, ctx) => {
            return typeof ctx.eval(expr[1], ctx) === 'string';
        },
        (ctx) => {
            const js = `typeof(${ctx.operands[0]})==='string'`;
            return new codegen_steps_1.Expression(js);
        },
    ],
    [
        'bin?',
        [],
        1,
        (expr, ctx) => {
            return ctx.eval(expr[1], ctx) instanceof Uint8Array;
        },
        (ctx) => {
            const js = `(${ctx.operands[0]})instanceof Uint8Array`;
            return new codegen_steps_1.Expression(js);
        },
    ],
    [
        'arr?',
        [],
        1,
        (expr, ctx) => {
            return ctx.eval(expr[1], ctx) instanceof Array;
        },
        (ctx) => {
            const js = `(${ctx.operands[0]})instanceof Array`;
            return new codegen_steps_1.Expression(js);
        },
    ],
    [
        'obj?',
        [],
        1,
        (expr, ctx) => {
            return util.type(ctx.eval(expr[1], ctx)) === 'object';
        },
        (ctx) => {
            ctx.link(util.type, 'type');
            const js = `type(${ctx.operands[0]})==='object'`;
            return new codegen_steps_1.Expression(js);
        },
    ],
];
