import type { Path } from '../../../json-pointer';
import { OpType } from '../../opcodes';
export type Operation = JsonPatchOperation | PredicateOperation | JsonPatchExtendedOperation;
export interface OperationBase {
    readonly op: OpType;
    readonly path: string | Path;
}
export type JsonPatchOperation = OperationAdd | OperationRemove | OperationReplace | OperationMove | OperationCopy | OperationTest;
export interface OperationAdd<T = unknown> extends OperationBase {
    readonly op: 'add';
    readonly value: T;
}
export interface OperationRemove<T = unknown> extends OperationBase {
    readonly op: 'remove';
    readonly oldValue?: T;
}
export interface OperationReplace<V = unknown, O = unknown> extends OperationBase {
    readonly op: 'replace';
    readonly value: V;
    readonly oldValue?: O;
}
export interface OperationCopy extends OperationBase {
    readonly op: 'copy';
    readonly from: string;
}
export interface OperationMove extends OperationBase {
    readonly op: 'move';
    readonly from: string;
}
export interface OperationTest<T = unknown> extends OperationBase {
    readonly op: 'test';
    readonly value: T;
    readonly not?: boolean;
}
export type PredicateOperation = FirstOrderPredicateOperation | SecondOrderPredicateOperation;
export type FirstOrderPredicateOperation = OperationTest | OperationDefined | OperationUndefined | OperationTestType | OperationTestString | OperationTestStringLen | OperationContains | OperationEnds | OperationStarts | OperationIn | OperationLess | OperationMore | OperationMatches | OperationType;
export type SecondOrderPredicateOperation = OperationAnd | OperationNot | OperationOr;
export type JsTypes = 'string' | 'number' | 'boolean' | 'object';
export type JsonPatchTypes = JsTypes | 'integer' | 'array' | 'null';
export interface OperationDefined extends OperationBase {
    readonly op: 'defined';
}
export interface OperationUndefined extends OperationBase {
    readonly op: 'undefined';
}
export interface OperationTestType extends OperationBase {
    readonly op: 'test_type';
    readonly type: JsonPatchTypes[];
}
export interface OperationTestString extends OperationBase {
    readonly op: 'test_string';
    readonly not?: boolean;
    readonly pos: number;
    readonly str: string;
}
export interface OperationTestStringLen extends OperationBase {
    readonly op: 'test_string_len';
    readonly not?: boolean;
    readonly len: number;
}
export interface OperationContains extends OperationBase {
    readonly op: 'contains';
    readonly value: string;
    readonly ignore_case?: boolean;
}
export interface OperationMatches extends OperationBase {
    readonly op: 'matches';
    readonly value: string;
    readonly ignore_case?: boolean;
}
export interface OperationEnds extends OperationBase {
    readonly op: 'ends';
    readonly value: string;
    readonly ignore_case?: boolean;
}
export interface OperationStarts extends OperationBase {
    readonly op: 'starts';
    readonly value: string;
    readonly ignore_case?: boolean;
}
export interface OperationType extends OperationBase {
    readonly op: 'type';
    readonly value: JsonPatchTypes;
}
export interface OperationIn extends OperationBase {
    readonly op: 'in';
    readonly value: unknown[];
}
export interface OperationLess extends OperationBase {
    readonly op: 'less';
    readonly value: number;
}
export interface OperationMore extends OperationBase {
    readonly op: 'more';
    readonly value: number;
}
export interface OperationAnd extends OperationBase {
    readonly op: 'and';
    readonly apply: PredicateOperation[];
}
export interface OperationNot extends OperationBase {
    readonly op: 'not';
    readonly apply: PredicateOperation[];
}
export interface OperationOr extends OperationBase {
    readonly op: 'or';
    readonly apply: PredicateOperation[];
}
export type JsonPatchExtendedOperation = OperationStrIns | OperationStrDel | OperationFlip | OperationInc | OperationSplit | OperationMerge | OperationExtend;
export interface OperationStrIns extends OperationBase {
    readonly op: 'str_ins';
    readonly pos: number;
    readonly str: string;
}
export interface OperationStrDel1 extends OperationBase {
    readonly op: 'str_del';
    readonly pos: number;
    readonly str: string;
}
export interface OperationStrDel2 extends OperationBase {
    readonly op: 'str_del';
    readonly pos: number;
    readonly len: number;
}
export interface OperationStrDel extends OperationBase {
    readonly op: 'str_del';
    readonly pos: number;
    readonly str?: string;
    readonly len?: number;
}
export interface OperationFlip extends OperationBase {
    readonly op: 'flip';
}
export interface OperationInc extends OperationBase {
    readonly op: 'inc';
    readonly inc: number;
}
export interface OperationSplit extends OperationBase {
    readonly op: 'split';
    pos: number;
    props?: object;
}
export interface OperationMerge extends OperationBase {
    readonly op: 'merge';
    pos: number;
    props?: object;
}
export interface OperationExtend extends OperationBase {
    readonly op: 'extend';
    props: Record<string, unknown>;
    deleteNull?: boolean;
}
