import type { CompactMergeOp } from '../codec/compact/types';
import { AbstractOp } from './AbstractOp';
import { OperationMerge } from '../types';
import { Path } from '../../json-pointer';
import { OPCODE } from '../constants';
import type { IMessagePackEncoder } from '../../json-pack/msgpack';
export declare class OpMerge extends AbstractOp<'merge'> {
    readonly pos: number;
    readonly props: object | null;
    constructor(path: Path, pos: number, props: object | null);
    op(): "merge";
    code(): OPCODE;
    apply(doc: unknown): {
        doc: unknown;
        old: unknown[];
    };
    private merge;
    toJson(parent?: AbstractOp): OperationMerge;
    toCompact(parent: undefined | AbstractOp, verbose: boolean): CompactMergeOp;
    encode(encoder: IMessagePackEncoder, parent?: AbstractOp): void;
}
