"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.OpMore = void 0;
const AbstractPredicateOp_1 = require("./AbstractPredicateOp");
const json_pointer_1 = require("../../json-pointer");
class OpMore extends AbstractPredicateOp_1.AbstractPredicateOp {
    constructor(path, value) {
        super(path);
        this.value = value;
    }
    op() {
        return 'more';
    }
    code() {
        return 36;
    }
    test(doc) {
        const { val } = (0, json_pointer_1.find)(doc, this.path);
        if (typeof val !== 'number')
            return false;
        const test = val > this.value;
        return test;
    }
    toJson(parent) {
        const op = {
            op: 'more',
            path: (0, json_pointer_1.formatJsonPointer)(parent ? this.path.slice(parent.path.length) : this.path),
            value: this.value,
        };
        return op;
    }
    toCompact(parent, verbose) {
        const opcode = verbose ? 'more' : 36;
        return [opcode, parent ? this.path.slice(parent.path.length) : this.path, this.value];
    }
    encode(encoder, parent) {
        encoder.encodeArrayHeader(3);
        encoder.writer.u8(36);
        encoder.encodeArray(parent ? this.path.slice(parent.path.length) : this.path);
        encoder.encodeNumber(this.value);
    }
}
exports.OpMore = OpMore;
