"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.$findRef = exports.$$findRef = void 0;
const codegen_1 = require("../../util/codegen");
const hasOwnProperty_1 = require("../../util/hasOwnProperty");
const $$findRef = (path) => {
    if (!path.length) {
        return {
            deps: [],
            js: `(function(){return function(val){return {val:val}}})`,
        };
    }
    let loop = '';
    for (let i = 0; i < path.length; i++) {
        const key = JSON.stringify(path[i]);
        loop += `
      obj = val;
      key = ${key};
      if (obj instanceof Array) {
        var length = obj.length;
        if (key === '-') key = length;
        else {
          var key2 = ${~~path[i]};
          ${String(~~path[i]) !== String(path[i]) ? `if ('' + key2 !== key) throw new Error('INVALID_INDEX');` : ''}
          ${~~path[i] < 0 ? `throw new Error('INVALID_INDEX');` : ''}
          key = key2;
        }
        val = obj[key];
      } else if (typeof obj === 'object' && !!obj) {
        val = hasOwnProperty(obj, key) ? obj[key] : undefined;
      } else throw new Error('NOT_FOUND');
    `;
    }
    const js = `(function(hasOwnProperty, path){
    return function(val) {
      var obj, key;
      ${loop}
      return {val:val, obj:obj, key:key};
    };
  })`;
    return {
        deps: [hasOwnProperty_1.hasOwnProperty, path],
        js,
    };
};
exports.$$findRef = $$findRef;
const $findRef = (path) => (0, codegen_1.compileClosure)((0, exports.$$findRef)(path));
exports.$findRef = $findRef;
