"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.CliCodecJson2 = void 0;
const JsonDecoder_1 = require("../../json-pack/json/JsonDecoder");
const JsonEncoder_1 = require("../../json-pack/json/JsonEncoder");
const bufferToUint8Array_1 = require("../../util/buffers/bufferToUint8Array");
class CliCodecJson2 {
    constructor(writer) {
        this.writer = writer;
        this.id = 'json2';
        this.description = 'JSON codec with 2 space pretty-printing';
        this.encoder = new JsonEncoder_1.JsonEncoder(writer);
        this.decoder = new JsonDecoder_1.JsonDecoder();
    }
    encode(value) {
        const uint8 = this.encoder.encode(value);
        const pojo = JSON.parse(Buffer.from(uint8).toString('utf8'));
        const json = JSON.stringify(pojo, null, 2) + '\n';
        return (0, bufferToUint8Array_1.bufferToUint8Array)(Buffer.from(json, 'utf8'));
    }
    decode(bytes) {
        return this.decoder.read(bytes);
    }
}
exports.CliCodecJson2 = CliCodecJson2;
