"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.defineBuiltinRoutes = void 0;
const tslib_1 = require("tslib");
const defineBuiltinRoutes = (router) => {
    const router2 = router.extend(({ t }) => ({
        '.echo': t
            .Function(t.any, t.any)
            .options({
            title: 'Echo input',
            description: 'Echo the input value back to the caller',
        })
            .implement((req) => tslib_1.__awaiter(void 0, void 0, void 0, function* () {
            return req;
        })),
        '.type': t
            .Function(t.undef, t.any)
            .options({
            title: 'Type information',
            description: 'Returns whole type system of this CLI.',
        })
            .implement((request, ctx) => tslib_1.__awaiter(void 0, void 0, void 0, function* () {
            return ctx.cli.types.exportTypes();
        })),
    }));
    return router2;
};
exports.defineBuiltinRoutes = defineBuiltinRoutes;
