"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.CliParamBool = void 0;
const tslib_1 = require("tslib");
const json_patch_1 = require("../../json-patch");
const json_pointer_1 = require("../../json-pointer");
class CliParamBool {
    constructor() {
        this.param = 'bool';
        this.short = 'b';
        this.title = 'Set boolean value';
        this.example = '--b/foo=true';
        this.createInstance = (cli, pointer, rawValue) => new (class {
            constructor() {
                this.onRequest = () => tslib_1.__awaiter(this, void 0, void 0, function* () {
                    const value = Boolean(JSON.parse(String(rawValue)));
                    const path = (0, json_pointer_1.toPath)(pointer);
                    cli.request = (0, json_patch_1.applyPatch)(cli.request, [{ op: 'add', path, value }], { mutate: true }).doc;
                });
            }
        })();
    }
}
exports.CliParamBool = CliParamBool;
