import type { Cli } from '../Cli';
import type { CliParam } from '../types';
export declare class CliParamFormat implements CliParam {
    readonly param = "format";
    readonly short = "fmt";
    readonly title = "Codec to use for req/res";
    readonly example = "--fmt=json:cbor";
    readonly help = "Codec format to use for encoding/decoding request/response values. To specify both request and response codecs use \"<codec>\", or \"<reqCodec>:<resCodec>\" to specify them separately.";
    readonly examples: string[];
    readonly createInstance: (cli: Cli, pointer: string, value: unknown) => {
        readonly onParam: () => Promise<void>;
    };
}
