"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.CliParamVersion = void 0;
const tslib_1 = require("tslib");
class CliParamVersion {
    constructor() {
        this.param = 'version';
        this.short = 'v';
        this.title = 'Print version and exit';
        this.createInstance = (cli, pointer, value) => new (class {
            constructor() {
                this.onParam = () => tslib_1.__awaiter(this, void 0, void 0, function* () {
                    var _a;
                    const version = (_a = cli.options.version) !== null && _a !== void 0 ? _a : '0.0.0-unknown';
                    cli.stdout.write(version + '\n');
                    cli.exit(0);
                });
            }
        })();
    }
}
exports.CliParamVersion = CliParamVersion;
