"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.SchemaBuilder = void 0;
class SchemaBuilder {
    get str() {
        return this.String();
    }
    get num() {
        return this.Number();
    }
    get bool() {
        return this.Boolean();
    }
    get undef() {
        return this.Const(undefined);
    }
    get nil() {
        return this.Const(null);
    }
    get arr() {
        return this.Array(this.any);
    }
    get obj() {
        return this.Object();
    }
    get bin() {
        return this.Binary(this.any);
    }
    get any() {
        return this.Any();
    }
    get fn() {
        return this.Function(this.any, this.any);
    }
    get fn$() {
        return this.Function$(this.any, this.any);
    }
    Boolean(a, b) {
        if (typeof a === 'string')
            return this.Boolean(Object.assign({ id: a }, (b || {})));
        return Object.assign({ __t: 'bool' }, (a || {}));
    }
    Number(options) {
        return Object.assign({ __t: 'num' }, options);
    }
    String(a, b) {
        if (typeof a === 'string')
            return this.String(Object.assign({ id: a }, (b || {})));
        return Object.assign({ __t: 'str' }, (a || {}));
    }
    Binary(type, options = {}) {
        return Object.assign({ __t: 'bin', type }, options);
    }
    Array(a, b, c) {
        if (typeof a === 'string')
            return this.Array(b, Object.assign({ id: a }, (c || {})));
        return Object.assign(Object.assign({ __t: 'arr' }, b), { type: a });
    }
    Const(value, options) {
        return Object.assign({ __t: 'const', value: value }, options);
    }
    Tuple(...types) {
        return { __t: 'tup', types };
    }
    fields(...fields) {
        return fields;
    }
    Object(...args) {
        const first = args[0];
        if (args.length === 1 &&
            first &&
            typeof first === 'object' &&
            first.fields instanceof Array)
            return Object.assign({ __t: 'obj' }, first);
        if (args.length >= 1 && args[0] instanceof Array)
            return this.Object(Object.assign({ fields: args[0] }, args[1]));
        return this.Object({ fields: args });
    }
    Field(key, type, options = {}) {
        return Object.assign({ __t: 'field', key,
            type }, options);
    }
    FieldOpt(key, type, options = {}) {
        return Object.assign(Object.assign({ __t: 'field', key,
            type }, options), { optional: true });
    }
    prop(key, type, options = {}) {
        return Object.assign({ __t: 'field', key,
            type }, options);
    }
    propOpt(key, type, options = {}) {
        return Object.assign(Object.assign({ __t: 'field', key,
            type }, options), { optional: true });
    }
    Any(options = {}) {
        return Object.assign({ __t: 'any' }, options);
    }
    Ref(ref) {
        return {
            __t: 'ref',
            ref: ref,
        };
    }
    Or(...types) {
        return {
            __t: 'or',
            types,
            discriminator: ['num', -1],
        };
    }
    Function(req, res) {
        return {
            __t: 'fn',
            req,
            res,
        };
    }
    Function$(req, res) {
        return {
            __t: 'fn$',
            req,
            res,
        };
    }
}
exports.SchemaBuilder = SchemaBuilder;
