"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.TypeExportContext = void 0;
class TypeExportContext {
    constructor() {
        this.refs = new Map();
    }
    mentionRef(ref) {
        if (!this.refs.has(ref))
            this.refs.set(ref, 'mentioned');
    }
    nextMentionedRef() {
        for (const [ref, type] of this.refs)
            if (type === 'mentioned')
                return ref;
        return undefined;
    }
    visitRef(ref) {
        this.refs.set(ref, 'visited');
    }
}
exports.TypeExportContext = TypeExportContext;
