import { Observable } from 'rxjs';
import { RpcErrorValue } from './error';
import { Value } from '../../messages/Value';
import { StaticRpcMethod } from '../methods/StaticRpcMethod';
import type { Call } from './types';
import type { RpcMethod } from '../types';
import type { StreamingRpcMethod } from '../methods/StreamingRpcMethod';
export interface RpcApiCallerOptions<Ctx = unknown> {
    getMethod: (name: string) => undefined | StaticRpcMethod<Ctx> | StreamingRpcMethod<Ctx>;
    preCallBufferSize?: number;
    wrapInternalError?: (error: unknown) => unknown;
}
export declare class RpcCaller<Ctx = unknown> {
    protected readonly getMethod: RpcApiCallerOptions<Ctx>['getMethod'];
    protected readonly preCallBufferSize: number;
    protected readonly wrapInternalError: (error: unknown) => unknown;
    constructor({ getMethod, preCallBufferSize, wrapInternalError, }: RpcApiCallerOptions<Ctx>);
    exists(name: string): boolean;
    getMethodStrict(name: string): StaticRpcMethod<Ctx> | StreamingRpcMethod<Ctx>;
    info(name: string): Pick<RpcMethod, 'pretty' | 'isStreaming'>;
    protected validate(method: StaticRpcMethod<Ctx> | StreamingRpcMethod<Ctx>, request: unknown): void;
    protected wrapValidationError(error: unknown): RpcErrorValue;
    call(name: string, request: unknown, ctx: Ctx): Promise<Value<unknown>>;
    notification(name: string, request: unknown, ctx: Ctx): Promise<void>;
    createCall(name: string, ctx: Ctx): Call;
    call$(name: string, request$: Observable<unknown>, ctx: Ctx): Observable<Value>;
}
