import { StaticRpcClient } from './StaticRpcClient';
import { RpcMessageCodec } from '../../codec/types';
import { JsonValueCodec } from '../../../../json-pack/codecs/types';
import type { Observable } from 'rxjs';
import type { RpcClient } from './types';
export interface StaticRpcClientOptions {
    send: (buf: Uint8Array) => Promise<Uint8Array>;
    msgCodec: RpcMessageCodec;
    reqCodec: JsonValueCodec;
    resCodec?: JsonValueCodec;
    client: StaticRpcClient;
}
export declare class EncodedStaticRpcClient implements RpcClient {
    readonly client: StaticRpcClient;
    constructor({ send, msgCodec, reqCodec, resCodec, client }: StaticRpcClientOptions);
    call$(method: string, data: unknown | Observable<unknown>): Observable<unknown>;
    call(method: string, request: unknown): Promise<unknown>;
    notify(method: string, data: undefined | unknown): void;
}
