import { StaticRpcClientOptions } from './StaticRpcClient';
import { EncodedStaticRpcClient } from './EncodedStaticRpcClient';
import type { RpcMessageCodec } from '../../codec/types';
import type { JsonValueCodec } from '../../../../json-pack/codecs/types';
import type { Observable } from 'rxjs';
import type { RpcClient } from './types';
type IFetch = typeof fetch;
export interface FetchRpcClientOptions extends StaticRpcClientOptions {
    url: string;
    msgCodec: RpcMessageCodec;
    reqCodec: JsonValueCodec;
    resCodec?: JsonValueCodec;
    fetch?: IFetch;
}
export declare class FetchRpcClient implements RpcClient {
    readonly client: EncodedStaticRpcClient;
    constructor(options: FetchRpcClientOptions);
    call$(method: string, data: unknown | Observable<unknown>): Observable<unknown>;
    call(method: string, request: unknown): Promise<unknown>;
    notify(method: string, data: undefined | unknown): void;
}
export {};
