import { Observable } from 'rxjs';
import * as msg from '../../messages';
import { TimedQueue } from '../../util/TimedQueue';
import type { RpcClient } from './types';
export interface StreamingRpcClientOptions {
    send: (messages: msg.ReactiveRpcClientMessage[]) => void;
    bufferSize?: number;
    bufferTime?: number;
}
export declare class StreamingRpcClient implements RpcClient {
    private id;
    readonly buffer: TimedQueue<msg.ReactiveRpcClientMessage>;
    private readonly calls;
    constructor({ send, bufferSize, bufferTime }: StreamingRpcClientOptions);
    getInflightCallCount(): number;
    onMessages(messages: msg.ReactiveRpcServerMessage[]): void;
    onMessage(message: msg.ReactiveRpcServerMessage): void;
    onResponseComplete(message: msg.ResponseCompleteMessage): void;
    onResponseData(message: msg.ResponseDataMessage): void;
    onResponseError(message: msg.ResponseErrorMessage): void;
    onRequestUnsubscribe(message: msg.RequestUnsubscribeMessage): void;
    call$(method: string, data: unknown): Observable<unknown>;
    call$(method: string, data: Observable<unknown>): Observable<unknown>;
    call(method: string, request: unknown): Promise<unknown>;
    notify(method: string, data: undefined | unknown): void;
    stop(reason?: string): void;
    disconnect(): void;
}
