"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.StreamingRpcMethod = void 0;
const rxjs_1 = require("rxjs");
class StreamingRpcMethod {
    constructor(options) {
        this.isStreaming = true;
        const { call$, onPreCall, pretty, validate, req, res, preCallBufferSize } = options;
        this.pretty = !!pretty;
        this.validate = validate;
        this.onPreCall = onPreCall;
        this.req = req;
        this.res = res;
        this.preCallBufferSize = preCallBufferSize;
        this.call = (request, ctx) => (0, rxjs_1.firstValueFrom)(call$((0, rxjs_1.of)(request), ctx));
        this.call$ = call$;
    }
}
exports.StreamingRpcMethod = StreamingRpcMethod;
