"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.validateMethod = exports.validateId = void 0;
const caller_1 = require("./caller");
const validateId = (id) => {
    if (typeof id !== 'number' || !Number.isInteger(id) || id < 0) {
        throw caller_1.RpcError.value(caller_1.RpcError.validation('Invalid id'));
    }
};
exports.validateId = validateId;
const validateMethod = (method) => {
    if (!method || typeof method !== 'string' || method.length > 64) {
        throw caller_1.RpcError.value(caller_1.RpcError.validation('Invalid method'));
    }
};
exports.validateMethod = validateMethod;
