import { Router } from '../../../util/router';
import { RpcMessageBatchProcessor } from '../../common/rpc/RpcMessageBatchProcessor';
import { ConnectionContext } from '../context';
import { RpcCodecs } from '../../common/codec/RpcCodecs';
import type { Codecs } from '../../../json-pack/codecs/Codecs';
import type { TemplatedApp, HttpMethodPermissive, JsonRouteHandler } from './types';
import type { RouteHandler } from './types';
import type { RpcCaller } from '../../common/rpc/caller/RpcCaller';
export interface RpcAppOptions {
    uws: TemplatedApp;
    maxRequestBodySize: number;
    codecs: Codecs;
    caller: RpcCaller;
}
export declare class RpcApp<Ctx extends ConnectionContext> {
    protected readonly options: RpcAppOptions;
    readonly codecs: RpcCodecs;
    protected readonly app: TemplatedApp;
    protected readonly maxRequestBodySize: number;
    protected readonly router: Router;
    protected readonly batchProcessor: RpcMessageBatchProcessor<Ctx>;
    constructor(options: RpcAppOptions);
    enableCors(): void;
    routeRaw(method: HttpMethodPermissive, path: string, handler: RouteHandler<Ctx>): void;
    route(method: HttpMethodPermissive, path: string, handler: JsonRouteHandler<Ctx>): void;
    enableHttpPing(path?: string): this;
    enableHttpRpc(path?: string): this;
    enableWsRpc(path?: string): this;
    startRouting(): void;
}
