"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.BufferSubject = void 0;
const rxjs_1 = require("rxjs");
const caller_1 = require("../../reactive-rpc/common/rpc/caller");
class BufferSubject extends rxjs_1.Subject {
    constructor(bufferSize) {
        super();
        this.bufferSize = bufferSize;
        this.buffer = [];
        this.isBuffering = true;
    }
    _subscribe(subscriber) {
        this._throwIfClosed();
        const subscription = this._innerSubscribe(subscriber);
        const { buffer } = this;
        for (let i = 0; i < buffer.length && !subscriber.closed; i += 1) {
            subscriber.next(buffer[i]);
        }
        this._checkFinalizedStatuses(subscriber);
        return subscription;
    }
    next(value) {
        if (this.isBuffering) {
            if (this.buffer.length >= this.bufferSize) {
                this.error(caller_1.RpcError.fromCode(caller_1.RpcErrorCodes.BUFFER_OVERFLOW));
                return;
            }
            this.buffer.push(value);
        }
        super.next(value);
    }
    flush() {
        this.isBuffering = false;
        this.buffer = [];
    }
}
exports.BufferSubject = BufferSubject;
