import { readFileSync } from 'fs';
import { MsgPackEncoder } from '../json-pack/msgpack';
import { CborEncoder } from '../json-pack/cbor/CborEncoder';
import * as JSONB from '../json-binary';
import arg from 'arg';
const args = arg({
    '--format': String,
    '--cbor': Boolean,
}, {
    argv: process.argv,
});
const ALLOWED_FORMATS = new Set(['msgpack', 'messagepack', 'cbor']);
const format = args['--cbor']
    ? 'cbor'
    : String(args['--format'] ?? 'msgpack').toLowerCase();
if (!ALLOWED_FORMATS.has(format))
    throw new Error(`Unknown format: ${format}`);
try {
    switch (format) {
        case 'msgpack':
        case 'messagepack': {
            const encoder = new MsgPackEncoder();
            const buf = readFileSync(0);
            const doc = JSONB.parse(buf.toString());
            const encoded = encoder.encode(doc);
            process.stdout.write(encoded);
            break;
        }
        case 'cbor': {
            const encoder = new CborEncoder();
            const buf = readFileSync(0);
            const doc = JSONB.parse(buf.toString());
            const encoded = encoder.encode(doc);
            process.stdout.write(encoded);
            break;
        }
    }
}
catch (error) {
    const output = error instanceof Error ? error.message : String(error);
    process.stderr.write(output + '\n');
    process.exit(1);
}
