import { isUint8Array } from '../util/buffers/isUint8Array';
const { isArray } = Array;
const objectKeys = Object.keys;
export const cloneBinary = (obj) => {
    if (!obj)
        return obj;
    if (isArray(obj)) {
        const arr = [];
        const length = obj.length;
        for (let i = 0; i < length; i++)
            arr.push(cloneBinary(obj[i]));
        return arr;
    }
    else if (typeof obj === 'object') {
        if (isUint8Array(obj))
            return new Uint8Array(obj);
        const keys = objectKeys(obj);
        const length = keys.length;
        const newObject = {};
        for (let i = 0; i < length; i++) {
            const key = keys[i];
            newObject[key] = cloneBinary(obj[key]);
        }
        return newObject;
    }
    return obj;
};
