export interface ITimestampStruct {
    readonly sid: number;
    time: number;
}
export interface ITimespanStruct extends ITimestampStruct {
    readonly span: number;
}
export interface IClock extends ITimestampStruct {
    tick(cycles: number): ITimestampStruct;
}
export interface IVectorClock extends IClock {
    readonly peers: Map<number, ITimestampStruct>;
    observe(ts: ITimestampStruct, span: number): void;
    clone(): IVectorClock;
    fork(sessionId: number): IVectorClock;
    toString(tab?: string): string;
}
