import { Timestamp, toDisplayString } from './clock';
export class NewConOp {
    id;
    val;
    constructor(id, val) {
        this.id = id;
        this.val = val;
    }
    span() {
        return 1;
    }
    name() {
        return 'new_con';
    }
    toString(tab = '') {
        const val = this.val;
        const valFormatted = val instanceof Timestamp
            ? `{ ${toDisplayString(val)} }`
            : val instanceof Uint8Array
                ? val.length < 13
                    ? `Uint8Array { ${('' + val).replaceAll(',', ', ')} }`
                    : `Uint8Array(${val.length})`
                : `{ ${JSON.stringify(val)} }`;
        return `"${this.name()}" ${toDisplayString(this.id)} ${valFormatted}`;
    }
}
export class NewValOp {
    id;
    constructor(id) {
        this.id = id;
    }
    span() {
        return 1;
    }
    name() {
        return 'new_val';
    }
    toString() {
        return `"${this.name()}" ${toDisplayString(this.id)}`;
    }
}
export class NewObjOp {
    id;
    constructor(id) {
        this.id = id;
    }
    span() {
        return 1;
    }
    name() {
        return 'new_obj';
    }
    toString() {
        return `"${this.name()}" ${toDisplayString(this.id)}`;
    }
}
export class NewVecOp {
    id;
    constructor(id) {
        this.id = id;
    }
    span() {
        return 1;
    }
    name() {
        return 'new_vec';
    }
    toString() {
        return `"${this.name()}" ${toDisplayString(this.id)}`;
    }
}
export class NewStrOp {
    id;
    constructor(id) {
        this.id = id;
    }
    span() {
        return 1;
    }
    name() {
        return 'new_str';
    }
    toString() {
        return `"${this.name()}" ${toDisplayString(this.id)}`;
    }
}
export class NewBinOp {
    id;
    constructor(id) {
        this.id = id;
    }
    span() {
        return 1;
    }
    name() {
        return 'new_bin';
    }
    toString(tab = '') {
        return `"${this.name()}" ${toDisplayString(this.id)}`;
    }
}
export class NewArrOp {
    id;
    constructor(id) {
        this.id = id;
    }
    span() {
        return 1;
    }
    name() {
        return 'new_arr';
    }
    toString() {
        return `"${this.name()}" ${toDisplayString(this.id)}`;
    }
}
export class InsValOp {
    id;
    obj;
    val;
    constructor(id, obj, val) {
        this.id = id;
        this.obj = obj;
        this.val = val;
    }
    span() {
        return 1;
    }
    name() {
        return 'ins_val';
    }
    toString(tab = '') {
        return `"${this.name()}" ${toDisplayString(this.id)}!${this.span()}, obj = ${toDisplayString(this.obj)}, val = ${toDisplayString(this.val)}`;
    }
}
export class InsObjOp {
    id;
    obj;
    data;
    constructor(id, obj, data) {
        this.id = id;
        this.obj = obj;
        this.data = data;
    }
    span() {
        return 1;
    }
    name() {
        return 'ins_obj';
    }
    toString(tab = '') {
        let out = `"${this.name()}" ${toDisplayString(this.id)}!${this.span()}, obj = ${toDisplayString(this.obj)}`;
        for (let i = 0; i < this.data.length; i++) {
            const isLast = i === this.data.length - 1;
            out += `\n${tab}  ${isLast ? '└─' : '├─'} ${JSON.stringify(this.data[i][0])}: ${toDisplayString(this.data[i][1])}`;
        }
        return out;
    }
}
export class InsVecOp {
    id;
    obj;
    data;
    constructor(id, obj, data) {
        this.id = id;
        this.obj = obj;
        this.data = data;
    }
    span() {
        return 1;
    }
    name() {
        return 'ins_vec';
    }
    toString(tab = '') {
        let out = `"${this.name()}" ${toDisplayString(this.id)}!${this.span()}, obj = ${toDisplayString(this.obj)}`;
        for (let i = 0; i < this.data.length; i++) {
            const isLast = i === this.data.length - 1;
            out += `\n${tab}  ${isLast ? '└─' : '├─'} ${JSON.stringify(this.data[i][0])}: ${toDisplayString(this.data[i][1])}`;
        }
        return out;
    }
}
export class InsStrOp {
    id;
    obj;
    ref;
    data;
    constructor(id, obj, ref, data) {
        this.id = id;
        this.obj = obj;
        this.ref = ref;
        this.data = data;
    }
    span() {
        return this.data.length;
    }
    name() {
        return 'ins_str';
    }
    toString() {
        return `"${this.name()}" ${toDisplayString(this.id)}!${this.span()}, obj = ${toDisplayString(this.obj)} { ${toDisplayString(this.ref)} ← ${JSON.stringify(this.data)} }`;
    }
}
export class InsBinOp {
    id;
    obj;
    ref;
    data;
    constructor(id, obj, ref, data) {
        this.id = id;
        this.obj = obj;
        this.ref = ref;
        this.data = data;
    }
    span() {
        return this.data.length;
    }
    name() {
        return 'ins_bin';
    }
    toString(tab = '') {
        const ref = toDisplayString(this.ref);
        return `"${this.name()}" ${toDisplayString(this.id)}!${this.span()}, obj = ${toDisplayString(this.obj)} { ${ref} ← ${this.data} }`;
    }
}
export class InsArrOp {
    id;
    obj;
    ref;
    data;
    constructor(id, obj, ref, data) {
        this.id = id;
        this.obj = obj;
        this.ref = ref;
        this.data = data;
    }
    span() {
        return this.data.length;
    }
    name() {
        return 'ins_arr';
    }
    toString() {
        return `"${this.name()}" ${toDisplayString(this.id)}!${this.span()}, obj = ${toDisplayString(this.obj)} { ${toDisplayString(this.ref)} ← ${this.data.map(toDisplayString).join(', ')} }`;
    }
}
export class DelOp {
    id;
    obj;
    what;
    constructor(id, obj, what) {
        this.id = id;
        this.obj = obj;
        this.what = what;
    }
    span() {
        return 1;
    }
    name() {
        return 'del';
    }
    toString() {
        const spans = this.what.map((span) => toDisplayString(span) + '!' + span.span).join(', ');
        return `"${this.name()}" ${toDisplayString(this.id)}, obj = ${toDisplayString(this.obj)} { ${spans} }`;
    }
}
export class NopOp {
    id;
    len;
    constructor(id, len) {
        this.id = id;
        this.len = len;
    }
    span() {
        return this.len;
    }
    name() {
        return 'nop';
    }
    toString() {
        return `"${this.name()}" ${toDisplayString(this.id)}!${this.len}`;
    }
}
