import { Model } from '..';
import { s } from '../../json-crdt-patch';
const schema = s.obj({
    text: s.con('hello'),
    counter: s.con(0),
    checked: s.con(true),
    friend: s.obj({
        name: s.con('John'),
        age: s.con(42),
        tags: s.arr([s.con('foo'), s.con('bar')]),
    }),
});
const model = Model.withLogicalClock(1234).setSchema(schema);
console.log(model + '');
console.log(model.view().friend.name);
console.log(model.view().friend.tags[1]);
console.log(model.api.node.get('text').view());
console.log(model.api.node.get('friend').get('name').view());
