import { CrdtReader } from '../../../../json-crdt-patch/util/binary/CrdtReader';
import { CborDecoderBase } from '../../../../json-pack/cbor/CborDecoderBase';
export class ViewDecoder extends CborDecoderBase {
    time = -1;
    constructor() {
        super(new CrdtReader());
    }
    decode(data) {
        const reader = this.reader;
        this.time = -1;
        reader.reset(data);
        const isServerTime = reader.u8() === 0;
        if (isServerTime) {
            this.time = reader.vu57();
        }
        else {
            reader.x += 4;
        }
        return this.cRoot();
    }
    ts() {
        if (this.time < 0)
            this.reader.idSkip();
        else
            this.reader.vu57Skip();
    }
    cRoot() {
        const reader = this.reader;
        const peek = reader.uint8[reader.x];
        return !peek ? undefined : this.cNode();
    }
    cNode() {
        const reader = this.reader;
        this.ts();
        const octet = reader.u8();
        const major = octet >> 5;
        const minor = octet & 0b11111;
        const length = minor < 24 ? minor : minor === 24 ? reader.u8() : minor === 25 ? reader.u16() : reader.u32();
        switch (major) {
            case 0:
                return this.cCon(length);
            case 1:
                return this.cNode();
            case 3:
                return this.cVec(length);
            case 2:
                return this.cObj(length);
            case 4:
                return this.cStr(length);
            case 5:
                return this.cBin(length);
            case 6:
                return this.cArr(length);
        }
        return undefined;
    }
    cCon(length) {
        return !length ? this.val() : (this.ts(), null);
    }
    cObj(length) {
        const obj = {};
        for (let i = 0; i < length; i++) {
            const key = this.key();
            const value = this.cNode();
            if (value !== undefined)
                obj[key] = value;
        }
        return obj;
    }
    cVec(length) {
        const reader = this.reader;
        const obj = [];
        for (let i = 0; i < length; i++) {
            const octet = reader.peak();
            if (!octet) {
                reader.x++;
                obj.push(undefined);
            }
            else
                obj.push(this.cNode());
        }
        return obj;
    }
    cArr(length) {
        const arr = [];
        for (let i = 0; i < length; i++) {
            const values = this.cArrChunk();
            if (values && values.length)
                arr.push(...values);
        }
        return arr;
    }
    cArrChunk() {
        const [deleted, length] = this.reader.b1vu28();
        this.ts();
        if (deleted) {
            return undefined;
        }
        else {
            const values = [];
            for (let i = 0; i < length; i++)
                values.push(this.cNode());
            return values;
        }
    }
    cStr(length) {
        const reader = this.reader;
        let str = '';
        for (let i = 0; i < length; i++) {
            this.ts();
            const isTombstone = reader.uint8[reader.x] === 0;
            if (isTombstone) {
                reader.x++;
                reader.vu39Skip();
                continue;
            }
            const text = this.val();
            str += text;
        }
        return str;
    }
    cBin(length) {
        const reader = this.reader;
        const buffers = [];
        let totalLength = 0;
        for (let i = 0; i < length; i++) {
            const [deleted, length] = reader.b1vu28();
            this.ts();
            if (deleted)
                continue;
            buffers.push(reader.buf(length));
            totalLength += length;
        }
        const res = new Uint8Array(totalLength);
        let offset = 0;
        for (let i = 0; i < buffers.length; i++) {
            const byteLength = buffers[i].length;
            res.set(buffers[i], offset);
            offset += byteLength;
        }
        return res;
    }
}
