import * as nodes from '../../../nodes';
import { ClockDecoder } from '../../../../json-crdt-patch/codec/clock/ClockDecoder';
import { ITimestampStruct } from '../../../../json-crdt-patch/clock';
import { Model } from '../../../model/Model';
import type * as t from './types';
export declare class Decoder {
    protected time?: number;
    protected clockDecoder?: ClockDecoder;
    decode(doc: t.JsonCrdtCompactDocument): Model;
    protected ts(x: t.JsonCrdtCompactTimestamp): ITimestampStruct;
    protected decNode(model: Model, node: t.JsonCrdtCompactNode): nodes.JsonNode;
    protected decCon(doc: Model, node: t.JsonCrdtCompactCon): nodes.ConNode;
    protected decVal(doc: Model, node: t.JsonCrdtCompactVal): nodes.ValNode;
    protected decObj(model: Model, node: t.JsonCrdtCompactObj): nodes.ObjNode;
    protected decVec(model: Model, node: t.JsonCrdtCompactVec): nodes.VecNode;
    protected decStr(doc: Model, node: t.JsonCrdtCompactStr): nodes.StrNode;
    protected decBin(doc: Model, node: t.JsonCrdtCompactBin): nodes.BinNode;
    protected decArr(doc: Model, node: t.JsonCrdtCompactArr): nodes.ArrNode;
}
