import { updateNum } from '../json-hash';
import { ConNode, ValNode, ObjNode, VecNode, ArrNode } from './nodes';
import { AbstractRga } from './nodes/rga';
import { last2 } from '../util/trees/util2';
export const updateId = (state, id) => {
    const sid = id.sid;
    state = updateNum(state, sid >>> 0);
    state = updateNum(state, id.time);
    return state;
};
export const updateRga = (state, node) => {
    state = updateNum(state, node.length());
    state = updateNum(state, node.size());
    const maxIdChunk = last2(node.ids);
    if (maxIdChunk)
        state = updateId(state, maxIdChunk.id);
    return updateId(state, node.id);
};
export const updateNode = (state, node) => {
    if (node instanceof ConNode)
        return updateId(state, node.id);
    if (node instanceof ValNode) {
        const child = node.child();
        if (child)
            state = updateNode(state, child);
        return updateId(state, node.id);
    }
    if (node instanceof ObjNode || node instanceof VecNode) {
        node.children((child) => {
            state = updateNode(state, child);
        });
        return updateId(state, node.id);
    }
    if (node instanceof ArrNode) {
        node.children((child) => {
            state = updateNode(state, child);
        });
    }
    if (node instanceof AbstractRga)
        return updateRga(state, node);
    throw new Error('UNKNOWN_NODE');
};
export const hashNode = (node) => {
    return updateNode(5381, node) >>> 0;
};
export const hashModel = (model) => {
    return hashNode(model.root);
};
