import { toDisplayString, Timestamp } from '../../../json-crdt-patch/clock';
export class ConNode {
    id;
    val;
    constructor(id, val) {
        this.id = id;
        this.val = val;
    }
    children() { }
    child() {
        return undefined;
    }
    container() {
        return undefined;
    }
    view() {
        return this.val;
    }
    api = undefined;
    toString(tab) {
        const val = this.val;
        const valFormatted = val instanceof Uint8Array
            ? `Uint8Array { ${('' + val).replaceAll(',', ', ')} }`
            : `{ ${val instanceof Timestamp ? toDisplayString(val) : JSON.stringify(val)} }`;
        return `${this.constructor.name} ${toDisplayString(this.id)} ${valFormatted}`;
    }
}
