import { tick } from '../../../json-crdt-patch/clock';
import { AbstractRga } from '../rga/AbstractRga';
import { next } from '../../../util/trees/util';
export class StrChunk {
    id;
    span;
    del;
    data;
    len;
    p;
    l;
    r;
    p2;
    l2;
    r2;
    s;
    constructor(id, span, str) {
        this.id = id;
        this.span = span;
        this.len = str ? span : 0;
        this.del = !str;
        this.p = undefined;
        this.l = undefined;
        this.r = undefined;
        this.p2 = undefined;
        this.l2 = undefined;
        this.r2 = undefined;
        this.s = undefined;
        this.data = str;
    }
    merge(str) {
        this.data += str;
        this.span = this.data.length;
    }
    split(ticks) {
        if (!this.del) {
            const chunk = new StrChunk(tick(this.id, ticks), this.span - ticks, this.data.slice(ticks));
            this.data = this.data.slice(0, ticks);
            this.span = ticks;
            return chunk;
        }
        const chunk = new StrChunk(tick(this.id, ticks), this.span - ticks, '');
        this.span = ticks;
        return chunk;
    }
    delete() {
        this.del = true;
        this.data = '';
    }
    clone() {
        const chunk = new StrChunk(this.id, this.span, this.data);
        return chunk;
    }
}
export class StrNode extends AbstractRga {
    children() { }
    child() {
        return undefined;
    }
    container() {
        return undefined;
    }
    _view = '';
    view() {
        if (this._view)
            return this._view;
        let str = '';
        for (let chunk = this.first(); chunk; chunk = next(chunk))
            str += chunk.data;
        return (this._view = str);
    }
    api = undefined;
    createChunk(id, str) {
        return new StrChunk(id, str ? str.length : 0, str || '');
    }
    onChange() {
        this._view = '';
    }
    toStringName() {
        return super.toStringName();
    }
}
