import { ClockTable } from '../../json-crdt-patch/codec/clock/ClockTable';
import { PartialEdit } from './PartialEdit';
export class PartialEditFactory {
    decoder;
    encoder;
    constructor(decoder, encoder) {
        this.decoder = decoder;
        this.encoder = encoder;
    }
    startPartialEdit(clockBlob) {
        const reader = this.decoder.dec.reader;
        reader.reset(clockBlob);
        const clockTable = ClockTable.decode(reader);
        const partialEdit = new PartialEdit(this.decoder, this.encoder, clockTable);
        return partialEdit;
    }
}
