import * as util from '../util';
import { Expression } from '../codegen-steps';
const toInt = util.int;
export const bitwiseOperators = [
    [
        '&',
        ['bitAnd'],
        -1,
        (expr, ctx) => {
            return expr.slice(2).reduce((acc, e) => acc & toInt(ctx.eval(e, ctx)), toInt(ctx.eval(expr[1], ctx)));
        },
        (ctx) => {
            const js = ctx.operands.map((expr) => `(~~(${expr}))`).join('&');
            return new Expression(js);
        },
    ],
    [
        '|',
        ['bitOr'],
        -1,
        (expr, ctx) => {
            return expr.slice(2).reduce((acc, e) => acc | toInt(ctx.eval(e, ctx)), toInt(ctx.eval(expr[1], ctx)));
        },
        (ctx) => {
            const js = ctx.operands.map((expr) => `(~~(${expr}))`).join('|');
            return new Expression(js);
        },
    ],
    [
        '^',
        ['bitXor'],
        -1,
        (expr, ctx) => {
            return expr.slice(2).reduce((acc, e) => acc ^ toInt(ctx.eval(e, ctx)), toInt(ctx.eval(expr[1], ctx)));
        },
        (ctx) => {
            const js = ctx.operands.map((expr) => `(~~(${expr}))`).join('^');
            return new Expression(js);
        },
    ],
    [
        '~',
        ['bitNot'],
        1,
        (expr, ctx) => {
            return ~toInt(ctx.eval(expr[1], ctx));
        },
        (ctx) => {
            const js = `~(${ctx.operands[0]})`;
            return new Expression(js);
        },
    ],
];
